package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ID, PropertyAlias}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTimeSeriesRequest(
    alias: Optional[PropertyAlias] = Optional.Absent,
    assetId: Optional[ID] = Optional.Absent,
    propertyId: Optional[ID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest = {
    import DescribeTimeSeriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest
      .builder()
      .optionallyWith(
        alias.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeTimeSeriesRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeTimeSeriesRequest.wrap(buildAwsValue())
}
object DescribeTimeSeriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeTimeSeriesRequest =
      zio.aws.iotsitewise.model.DescribeTimeSeriesRequest(
        alias.map(value => value),
        assetId.map(value => value),
        propertyId.map(value => value)
      )
    def alias: Optional[PropertyAlias]
    def assetId: Optional[ID]
    def propertyId: Optional[ID]
    def getAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest
  ) extends zio.aws.iotsitewise.model.DescribeTimeSeriesRequest.ReadOnly {
    override val alias: Optional[PropertyAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeTimeSeriesRequest
  ): zio.aws.iotsitewise.model.DescribeTimeSeriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
