package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.DetailedErrorMessage
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetailedError(
    code: zio.aws.iotsitewise.model.DetailedErrorCode,
    message: DetailedErrorMessage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DetailedError = {
    import DetailedError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DetailedError
      .builder()
      .code(code.unwrap)
      .message(DetailedErrorMessage.unwrap(message): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DetailedError.ReadOnly =
    zio.aws.iotsitewise.model.DetailedError.wrap(buildAwsValue())
}
object DetailedError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DetailedError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DetailedError =
      zio.aws.iotsitewise.model.DetailedError(code, message)
    def code: zio.aws.iotsitewise.model.DetailedErrorCode
    def message: DetailedErrorMessage
    def getCode
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.DetailedErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, DetailedErrorMessage] =
      ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DetailedError
  ) extends zio.aws.iotsitewise.model.DetailedError.ReadOnly {
    override val code: zio.aws.iotsitewise.model.DetailedErrorCode =
      zio.aws.iotsitewise.model.DetailedErrorCode.wrap(impl.code())
    override val message: DetailedErrorMessage =
      zio.aws.iotsitewise.model.primitives.DetailedErrorMessage(impl.message())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DetailedError
  ): zio.aws.iotsitewise.model.DetailedError.ReadOnly = new Wrapper(impl)
}
