package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait DetailedErrorCode {
  def unwrap
      : software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode
}
object DetailedErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode
  ): zio.aws.iotsitewise.model.DetailedErrorCode = value match {
    case software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode.INCOMPATIBLE_COMPUTE_LOCATION =>
      val r = INCOMPATIBLE_COMPUTE_LOCATION
      r
    case software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode.INCOMPATIBLE_FORWARDING_CONFIGURATION =>
      val r = INCOMPATIBLE_FORWARDING_CONFIGURATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.DetailedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INCOMPATIBLE_COMPUTE_LOCATION
      extends zio.aws.iotsitewise.model.DetailedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode.INCOMPATIBLE_COMPUTE_LOCATION
  }
  case object INCOMPATIBLE_FORWARDING_CONFIGURATION
      extends zio.aws.iotsitewise.model.DetailedErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.DetailedErrorCode.INCOMPATIBLE_FORWARDING_CONFIGURATION
  }
}
