package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GatewayPlatform(
    greengrass: Optional[zio.aws.iotsitewise.model.Greengrass] =
      Optional.Absent,
    greengrassV2: Optional[zio.aws.iotsitewise.model.GreengrassV2] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform = {
    import GatewayPlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform
      .builder()
      .optionallyWith(greengrass.map(value => value.buildAwsValue()))(
        _.greengrass
      )
      .optionallyWith(greengrassV2.map(value => value.buildAwsValue()))(
        _.greengrassV2
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly =
    zio.aws.iotsitewise.model.GatewayPlatform.wrap(buildAwsValue())
}
object GatewayPlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.GatewayPlatform =
      zio.aws.iotsitewise.model.GatewayPlatform(
        greengrass.map(value => value.asEditable),
        greengrassV2.map(value => value.asEditable)
      )
    def greengrass: Optional[zio.aws.iotsitewise.model.Greengrass.ReadOnly]
    def greengrassV2: Optional[zio.aws.iotsitewise.model.GreengrassV2.ReadOnly]
    def getGreengrass
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Greengrass.ReadOnly] =
      AwsError.unwrapOptionField("greengrass", greengrass)
    def getGreengrassV2
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.GreengrassV2.ReadOnly] =
      AwsError.unwrapOptionField("greengrassV2", greengrassV2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform
  ) extends zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly {
    override val greengrass
        : Optional[zio.aws.iotsitewise.model.Greengrass.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greengrass())
        .map(value => zio.aws.iotsitewise.model.Greengrass.wrap(value))
    override val greengrassV2
        : Optional[zio.aws.iotsitewise.model.GreengrassV2.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greengrassV2())
        .map(value => zio.aws.iotsitewise.model.GreengrassV2.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GatewayPlatform
  ): zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly = new Wrapper(impl)
}
