package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ImageFileData
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImageFile(
    data: ImageFileData,
    `type`: zio.aws.iotsitewise.model.ImageFileType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ImageFile = {
    import ImageFile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ImageFile
      .builder()
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ImageFile.ReadOnly =
    zio.aws.iotsitewise.model.ImageFile.wrap(buildAwsValue())
}
object ImageFile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ImageFile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ImageFile =
      zio.aws.iotsitewise.model.ImageFile(data, `type`)
    def data: ImageFileData
    def `type`: zio.aws.iotsitewise.model.ImageFileType
    def getData: ZIO[Any, Nothing, ImageFileData] = ZIO.succeed(data)
    def getType: ZIO[Any, Nothing, zio.aws.iotsitewise.model.ImageFileType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ImageFile
  ) extends zio.aws.iotsitewise.model.ImageFile.ReadOnly {
    override val data: ImageFileData = zio.aws.iotsitewise.model.primitives
      .ImageFileData(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
    override val `type`: zio.aws.iotsitewise.model.ImageFileType =
      zio.aws.iotsitewise.model.ImageFileType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ImageFile
  ): zio.aws.iotsitewise.model.ImageFile.ReadOnly = new Wrapper(impl)
}
