package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Url, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImageLocation(id: ID, url: Url) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ImageLocation = {
    import ImageLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ImageLocation
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .url(Url.unwrap(url): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ImageLocation.ReadOnly =
    zio.aws.iotsitewise.model.ImageLocation.wrap(buildAwsValue())
}
object ImageLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ImageLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ImageLocation =
      zio.aws.iotsitewise.model.ImageLocation(id, url)
    def id: ID
    def url: Url
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ImageLocation
  ) extends zio.aws.iotsitewise.model.ImageLocation.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val url: Url = zio.aws.iotsitewise.model.primitives.Url(impl.url())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ImageLocation
  ): zio.aws.iotsitewise.model.ImageLocation.ReadOnly = new Wrapper(impl)
}
