package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAssetModelsResponse(
    assetModelSummaries: Iterable[zio.aws.iotsitewise.model.AssetModelSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse = {
    import ListAssetModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse
      .builder()
      .assetModelSummaries(assetModelSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetModelsResponse.wrap(buildAwsValue())
}
object ListAssetModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetModelsResponse =
      zio.aws.iotsitewise.model.ListAssetModelsResponse(
        assetModelSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assetModelSummaries
        : List[zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAssetModelSummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly
    ]] = ZIO.succeed(assetModelSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse
  ) extends zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly {
    override val assetModelSummaries
        : List[zio.aws.iotsitewise.model.AssetModelSummary.ReadOnly] = impl
      .assetModelSummaries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetModelSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse
  ): zio.aws.iotsitewise.model.ListAssetModelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
