package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{ID, MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAssetsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    assetModelId: Optional[ID] = Optional.Absent,
    filter: Optional[zio.aws.iotsitewise.model.ListAssetsFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest = {
    import ListAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        assetModelId.map(value => ID.unwrap(value): java.lang.String)
      )(_.assetModelId)
      .optionallyWith(filter.map(value => value.unwrap))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetsRequest.wrap(buildAwsValue())
}
object ListAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetsRequest =
      zio.aws.iotsitewise.model.ListAssetsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        assetModelId.map(value => value),
        filter.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def assetModelId: Optional[ID]
    def filter: Optional[zio.aws.iotsitewise.model.ListAssetsFilter]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAssetModelId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetModelId", assetModelId)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ListAssetsFilter] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
  ) extends zio.aws.iotsitewise.model.ListAssetsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
    override val assetModelId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetModelId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val filter: Optional[zio.aws.iotsitewise.model.ListAssetsFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.iotsitewise.model.ListAssetsFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
  ): zio.aws.iotsitewise.model.ListAssetsRequest.ReadOnly = new Wrapper(impl)
}
