package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAssociatedAssetsRequest(
    assetId: ID,
    hierarchyId: Optional[ID] = Optional.Absent,
    traversalDirection: Optional[zio.aws.iotsitewise.model.TraversalDirection] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest = {
    import ListAssociatedAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .optionallyWith(
        hierarchyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.hierarchyId)
      .optionallyWith(traversalDirection.map(value => value.unwrap))(
        _.traversalDirection
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.wrap(buildAwsValue())
}
object ListAssociatedAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest =
      zio.aws.iotsitewise.model.ListAssociatedAssetsRequest(
        assetId,
        hierarchyId.map(value => value),
        traversalDirection.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: ID
    def hierarchyId: Optional[ID]
    def traversalDirection
        : Optional[zio.aws.iotsitewise.model.TraversalDirection]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getHierarchyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("hierarchyId", hierarchyId)
    def getTraversalDirection
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.TraversalDirection] =
      AwsError.unwrapOptionField("traversalDirection", traversalDirection)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
  ) extends zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val hierarchyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.hierarchyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val traversalDirection
        : Optional[zio.aws.iotsitewise.model.TraversalDirection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.traversalDirection())
        .map(value => zio.aws.iotsitewise.model.TraversalDirection.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
  ): zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.ReadOnly =
    new Wrapper(impl)
}
