package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPortalsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest = {
    import ListPortalsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListPortalsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListPortalsRequest.wrap(buildAwsValue())
}
object ListPortalsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListPortalsRequest =
      zio.aws.iotsitewise.model.ListPortalsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest
  ) extends zio.aws.iotsitewise.model.ListPortalsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest
  ): zio.aws.iotsitewise.model.ListPortalsRequest.ReadOnly = new Wrapper(impl)
}
