package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait LoggingLevel {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.LoggingLevel
}
object LoggingLevel {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.LoggingLevel
  ): zio.aws.iotsitewise.model.LoggingLevel = value match {
    case software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.LoggingLevel =
      software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ERROR extends zio.aws.iotsitewise.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.LoggingLevel =
      software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.ERROR
  }
  case object INFO extends zio.aws.iotsitewise.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.LoggingLevel =
      software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.INFO
  }
  case object OFF extends zio.aws.iotsitewise.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.LoggingLevel =
      software.amazon.awssdk.services.iotsitewise.model.LoggingLevel.OFF
  }
}
