package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LoggingOptions(level: zio.aws.iotsitewise.model.LoggingLevel) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.LoggingOptions = {
    import LoggingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.LoggingOptions
      .builder()
      .level(level.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.LoggingOptions.ReadOnly =
    zio.aws.iotsitewise.model.LoggingOptions.wrap(buildAwsValue())
}
object LoggingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.LoggingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.LoggingOptions =
      zio.aws.iotsitewise.model.LoggingOptions(level)
    def level: zio.aws.iotsitewise.model.LoggingLevel
    def getLevel: ZIO[Any, Nothing, zio.aws.iotsitewise.model.LoggingLevel] =
      ZIO.succeed(level)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.LoggingOptions
  ) extends zio.aws.iotsitewise.model.LoggingOptions.ReadOnly {
    override val level: zio.aws.iotsitewise.model.LoggingLevel =
      zio.aws.iotsitewise.model.LoggingLevel.wrap(impl.level())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.LoggingOptions
  ): zio.aws.iotsitewise.model.LoggingOptions.ReadOnly = new Wrapper(impl)
}
