package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait PortalState {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.PortalState
}
object PortalState {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.PortalState
  ): zio.aws.iotsitewise.model.PortalState = value match {
    case software.amazon.awssdk.services.iotsitewise.model.PortalState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.PortalState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iotsitewise.model.PortalState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.iotsitewise.model.PortalState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.iotsitewise.model.PortalState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iotsitewise.model.PortalState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.PortalState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PortalState =
      software.amazon.awssdk.services.iotsitewise.model.PortalState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iotsitewise.model.PortalState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PortalState =
      software.amazon.awssdk.services.iotsitewise.model.PortalState.CREATING
  }
  case object UPDATING extends zio.aws.iotsitewise.model.PortalState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PortalState =
      software.amazon.awssdk.services.iotsitewise.model.PortalState.UPDATING
  }
  case object DELETING extends zio.aws.iotsitewise.model.PortalState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PortalState =
      software.amazon.awssdk.services.iotsitewise.model.PortalState.DELETING
  }
  case object ACTIVE extends zio.aws.iotsitewise.model.PortalState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PortalState =
      software.amazon.awssdk.services.iotsitewise.model.PortalState.ACTIVE
  }
  case object FAILED extends zio.aws.iotsitewise.model.PortalState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PortalState =
      software.amazon.awssdk.services.iotsitewise.model.PortalState.FAILED
  }
}
