package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProjectResource(id: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ProjectResource = {
    import ProjectResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ProjectResource
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ProjectResource.ReadOnly =
    zio.aws.iotsitewise.model.ProjectResource.wrap(buildAwsValue())
}
object ProjectResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ProjectResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ProjectResource =
      zio.aws.iotsitewise.model.ProjectResource(id)
    def id: ID
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ProjectResource
  ) extends zio.aws.iotsitewise.model.ProjectResource.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ProjectResource
  ): zio.aws.iotsitewise.model.ProjectResource.ReadOnly = new Wrapper(impl)
}
