package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{Timestamp, Description, Name, ID}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ProjectSummary(
    id: ID,
    name: Name,
    description: Optional[Description] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    lastUpdateDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ProjectSummary = {
    import ProjectSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ProjectSummary
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ProjectSummary.ReadOnly =
    zio.aws.iotsitewise.model.ProjectSummary.wrap(buildAwsValue())
}
object ProjectSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ProjectSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ProjectSummary =
      zio.aws.iotsitewise.model.ProjectSummary(
        id,
        name,
        description.map(value => value),
        creationDate.map(value => value),
        lastUpdateDate.map(value => value)
      )
    def id: ID
    def name: Name
    def description: Optional[Description]
    def creationDate: Optional[Timestamp]
    def lastUpdateDate: Optional[Timestamp]
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ProjectSummary
  ) extends zio.aws.iotsitewise.model.ProjectSummary.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val lastUpdateDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ProjectSummary
  ): zio.aws.iotsitewise.model.ProjectSummary.ReadOnly = new Wrapper(impl)
}
