package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait PropertyDataType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.PropertyDataType
}
object PropertyDataType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.PropertyDataType
  ): zio.aws.iotsitewise.model.PropertyDataType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.INTEGER =>
      val r = INTEGER
      r
    case software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.STRUCT =>
      val r = STRUCT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.PropertyDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyDataType =
      software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING extends zio.aws.iotsitewise.model.PropertyDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyDataType =
      software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.STRING
  }
  case object INTEGER extends zio.aws.iotsitewise.model.PropertyDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyDataType =
      software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.INTEGER
  }
  case object DOUBLE extends zio.aws.iotsitewise.model.PropertyDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyDataType =
      software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.DOUBLE
  }
  case object BOOLEAN extends zio.aws.iotsitewise.model.PropertyDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyDataType =
      software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.BOOLEAN
  }
  case object STRUCT extends zio.aws.iotsitewise.model.PropertyDataType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyDataType =
      software.amazon.awssdk.services.iotsitewise.model.PropertyDataType.STRUCT
  }
}
