package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.PropertyNotificationTopic
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PropertyNotification(
    topic: PropertyNotificationTopic,
    state: zio.aws.iotsitewise.model.PropertyNotificationState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PropertyNotification = {
    import PropertyNotification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PropertyNotification
      .builder()
      .topic(PropertyNotificationTopic.unwrap(topic): java.lang.String)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.PropertyNotification.ReadOnly =
    zio.aws.iotsitewise.model.PropertyNotification.wrap(buildAwsValue())
}
object PropertyNotification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PropertyNotification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PropertyNotification =
      zio.aws.iotsitewise.model.PropertyNotification(topic, state)
    def topic: PropertyNotificationTopic
    def state: zio.aws.iotsitewise.model.PropertyNotificationState
    def getTopic: ZIO[Any, Nothing, PropertyNotificationTopic] =
      ZIO.succeed(topic)
    def getState: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.PropertyNotificationState
    ] = ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PropertyNotification
  ) extends zio.aws.iotsitewise.model.PropertyNotification.ReadOnly {
    override val topic: PropertyNotificationTopic =
      zio.aws.iotsitewise.model.primitives
        .PropertyNotificationTopic(impl.topic())
    override val state: zio.aws.iotsitewise.model.PropertyNotificationState =
      zio.aws.iotsitewise.model.PropertyNotificationState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PropertyNotification
  ): zio.aws.iotsitewise.model.PropertyNotification.ReadOnly = new Wrapper(impl)
}
