package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters.*
sealed trait PropertyNotificationState {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState
}
object PropertyNotificationState {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState
  ): zio.aws.iotsitewise.model.PropertyNotificationState = value match {
    case software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.PropertyNotificationState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState =
      software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.iotsitewise.model.PropertyNotificationState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState =
      software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState.ENABLED
  }
  case object DISABLED
      extends zio.aws.iotsitewise.model.PropertyNotificationState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState =
      software.amazon.awssdk.services.iotsitewise.model.PropertyNotificationState.DISABLED
  }
}
