package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{Unlimited, NumberOfDays}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RetentionPeriod(
    numberOfDays: Optional[NumberOfDays] = Optional.Absent,
    unlimited: Optional[Unlimited] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod = {
    import RetentionPeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
      .builder()
      .optionallyWith(
        numberOfDays.map(value => NumberOfDays.unwrap(value): Integer)
      )(_.numberOfDays)
      .optionallyWith(
        unlimited.map(value => Unlimited.unwrap(value): java.lang.Boolean)
      )(_.unlimited)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly =
    zio.aws.iotsitewise.model.RetentionPeriod.wrap(buildAwsValue())
}
object RetentionPeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.RetentionPeriod =
      zio.aws.iotsitewise.model.RetentionPeriod(
        numberOfDays.map(value => value),
        unlimited.map(value => value)
      )
    def numberOfDays: Optional[NumberOfDays]
    def unlimited: Optional[Unlimited]
    def getNumberOfDays: ZIO[Any, AwsError, NumberOfDays] =
      AwsError.unwrapOptionField("numberOfDays", numberOfDays)
    def getUnlimited: ZIO[Any, AwsError, Unlimited] =
      AwsError.unwrapOptionField("unlimited", unlimited)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
  ) extends zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly {
    override val numberOfDays: Optional[NumberOfDays] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfDays())
      .map(value => zio.aws.iotsitewise.model.primitives.NumberOfDays(value))
    override val unlimited: Optional[Unlimited] = zio.aws.core.internal
      .optionalFromNullable(impl.unlimited())
      .map(value => zio.aws.iotsitewise.model.primitives.Unlimited(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
  ): zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly = new Wrapper(impl)
}
