package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  DashboardDefinition,
  Description,
  ClientToken,
  Name,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDashboardRequest(
    dashboardId: ID,
    dashboardName: Name,
    dashboardDescription: Optional[Description] = Optional.Absent,
    dashboardDefinition: DashboardDefinition,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest = {
    import UpdateDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest
      .builder()
      .dashboardId(ID.unwrap(dashboardId): java.lang.String)
      .dashboardName(Name.unwrap(dashboardName): java.lang.String)
      .optionallyWith(
        dashboardDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.dashboardDescription)
      .dashboardDefinition(
        DashboardDefinition.unwrap(dashboardDefinition): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdateDashboardRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateDashboardRequest.wrap(buildAwsValue())
}
object UpdateDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateDashboardRequest =
      zio.aws.iotsitewise.model.UpdateDashboardRequest(
        dashboardId,
        dashboardName,
        dashboardDescription.map(value => value),
        dashboardDefinition,
        clientToken.map(value => value)
      )
    def dashboardId: ID
    def dashboardName: Name
    def dashboardDescription: Optional[Description]
    def dashboardDefinition: DashboardDefinition
    def clientToken: Optional[ClientToken]
    def getDashboardId: ZIO[Any, Nothing, ID] = ZIO.succeed(dashboardId)
    def getDashboardName: ZIO[Any, Nothing, Name] = ZIO.succeed(dashboardName)
    def getDashboardDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("dashboardDescription", dashboardDescription)
    def getDashboardDefinition: ZIO[Any, Nothing, DashboardDefinition] =
      ZIO.succeed(dashboardDefinition)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest
  ) extends zio.aws.iotsitewise.model.UpdateDashboardRequest.ReadOnly {
    override val dashboardId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.dashboardId())
    override val dashboardName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.dashboardName())
    override val dashboardDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashboardDescription())
        .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val dashboardDefinition: DashboardDefinition =
      zio.aws.iotsitewise.model.primitives
        .DashboardDefinition(impl.dashboardDefinition())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateDashboardRequest
  ): zio.aws.iotsitewise.model.UpdateDashboardRequest.ReadOnly = new Wrapper(
    impl
  )
}
