package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  PropertyValueBooleanValue,
  PropertyValueDoubleValue,
  PropertyValueIntegerValue,
  PropertyValueStringValue
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Variant(
    stringValue: Optional[PropertyValueStringValue] = Optional.Absent,
    integerValue: Optional[PropertyValueIntegerValue] = Optional.Absent,
    doubleValue: Optional[PropertyValueDoubleValue] = Optional.Absent,
    booleanValue: Optional[PropertyValueBooleanValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Variant = {
    import Variant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Variant
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          PropertyValueStringValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        integerValue.map(value =>
          PropertyValueIntegerValue.unwrap(value): Integer
        )
      )(_.integerValue)
      .optionallyWith(
        doubleValue.map(value =>
          PropertyValueDoubleValue.unwrap(value): java.lang.Double
        )
      )(_.doubleValue)
      .optionallyWith(
        booleanValue.map(value =>
          PropertyValueBooleanValue.unwrap(value): java.lang.Boolean
        )
      )(_.booleanValue)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Variant.ReadOnly =
    zio.aws.iotsitewise.model.Variant.wrap(buildAwsValue())
}
object Variant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Variant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Variant =
      zio.aws.iotsitewise.model.Variant(
        stringValue.map(value => value),
        integerValue.map(value => value),
        doubleValue.map(value => value),
        booleanValue.map(value => value)
      )
    def stringValue: Optional[PropertyValueStringValue]
    def integerValue: Optional[PropertyValueIntegerValue]
    def doubleValue: Optional[PropertyValueDoubleValue]
    def booleanValue: Optional[PropertyValueBooleanValue]
    def getStringValue: ZIO[Any, AwsError, PropertyValueStringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getIntegerValue: ZIO[Any, AwsError, PropertyValueIntegerValue] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getDoubleValue: ZIO[Any, AwsError, PropertyValueDoubleValue] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getBooleanValue: ZIO[Any, AwsError, PropertyValueBooleanValue] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Variant
  ) extends zio.aws.iotsitewise.model.Variant.ReadOnly {
    override val stringValue: Optional[PropertyValueStringValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValue())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.PropertyValueStringValue(value)
        )
    override val integerValue: Optional[PropertyValueIntegerValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integerValue())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.PropertyValueIntegerValue(value)
        )
    override val doubleValue: Optional[PropertyValueDoubleValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.doubleValue())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.PropertyValueDoubleValue(value)
        )
    override val booleanValue: Optional[PropertyValueBooleanValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.booleanValue())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.PropertyValueBooleanValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Variant
  ): zio.aws.iotsitewise.model.Variant.ReadOnly = new Wrapper(impl)
}
