package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchPutPropertyError(
    entry: zio.aws.iottwinmaker.model.PropertyValueEntry,
    errorCode: String,
    errorMessage: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError = {
    import BatchPutPropertyError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
      .builder()
      .entry(entry.buildAwsValue())
      .errorCode(errorCode: java.lang.String)
      .errorMessage(errorMessage: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly =
    zio.aws.iottwinmaker.model.BatchPutPropertyError.wrap(buildAwsValue())
}
object BatchPutPropertyError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.BatchPutPropertyError =
      zio.aws.iottwinmaker.model
        .BatchPutPropertyError(entry.asEditable, errorCode, errorMessage)
    def entry: zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly
    def errorCode: String
    def errorMessage: String
    def getEntry: ZIO[
      Any,
      Nothing,
      zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly
    ] = ZIO.succeed(entry)
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
  ) extends zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly {
    override val entry: zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly =
      zio.aws.iottwinmaker.model.PropertyValueEntry.wrap(impl.entry())
    override val errorCode: String = impl.errorCode(): String
    override val errorMessage: String = impl.errorMessage(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
  ): zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly = new Wrapper(
    impl
  )
}
