package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  Description,
  Timestamp,
  ComponentTypeId,
  TwinMakerArn
}
import scala.jdk.CollectionConverters.*
final case class ComponentTypeSummary(
    arn: TwinMakerArn,
    componentTypeId: ComponentTypeId,
    creationDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.iottwinmaker.model.Status] = Optional.Absent,
    updateDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary = {
    import ComponentTypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ComponentTypeSummary.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentTypeSummary.wrap(buildAwsValue())
}
object ComponentTypeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentTypeSummary =
      zio.aws.iottwinmaker.model.ComponentTypeSummary(
        arn,
        componentTypeId,
        creationDateTime,
        description.map(value => value),
        status.map(value => value.asEditable),
        updateDateTime
      )
    def arn: TwinMakerArn
    def componentTypeId: ComponentTypeId
    def creationDateTime: Timestamp
    def description: Optional[Description]
    def status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly]
    def updateDateTime: Timestamp
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Status.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary
  ) extends zio.aws.iottwinmaker.model.ComponentTypeSummary.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iottwinmaker.model.Status.wrap(value))
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentTypeSummary
  ): zio.aws.iottwinmaker.model.ComponentTypeSummary.ReadOnly = new Wrapper(
    impl
  )
}
