package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  Timestamp,
  Description,
  ComponentTypeId,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class GetComponentTypeResponse(
    arn: TwinMakerArn,
    componentTypeId: ComponentTypeId,
    creationDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    extendsFrom: Optional[Iterable[ComponentTypeId]] = Optional.Absent,
    functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionResponse]
    ] = Optional.Absent,
    isAbstract: Optional[Boolean] = Optional.Absent,
    isSchemaInitialized: Optional[Boolean] = Optional.Absent,
    isSingleton: Optional[Boolean] = Optional.Absent,
    propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionResponse]
    ] = Optional.Absent,
    status: Optional[zio.aws.iottwinmaker.model.Status] = Optional.Absent,
    updateDateTime: Timestamp,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse = {
    import GetComponentTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        extendsFrom.map(value =>
          value.map { item =>
            ComponentTypeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.extendsFrom)
      .optionallyWith(
        functions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.functions)
      .optionallyWith(isAbstract.map(value => value: java.lang.Boolean))(
        _.isAbstract
      )
      .optionallyWith(
        isSchemaInitialized.map(value => value: java.lang.Boolean)
      )(_.isSchemaInitialized)
      .optionallyWith(isSingleton.map(value => value: java.lang.Boolean))(
        _.isSingleton
      )
      .optionallyWith(
        propertyDefinitions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyDefinitions)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetComponentTypeResponse.wrap(buildAwsValue())
}
object GetComponentTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetComponentTypeResponse =
      zio.aws.iottwinmaker.model.GetComponentTypeResponse(
        arn,
        componentTypeId,
        creationDateTime,
        description.map(value => value),
        extendsFrom.map(value => value),
        functions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        isAbstract.map(value => value),
        isSchemaInitialized.map(value => value),
        isSingleton.map(value => value),
        propertyDefinitions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        status.map(value => value.asEditable),
        updateDateTime,
        workspaceId
      )
    def arn: TwinMakerArn
    def componentTypeId: ComponentTypeId
    def creationDateTime: Timestamp
    def description: Optional[Description]
    def extendsFrom: Optional[List[ComponentTypeId]]
    def functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly]
    ]
    def isAbstract: Optional[Boolean]
    def isSchemaInitialized: Optional[Boolean]
    def isSingleton: Optional[Boolean]
    def propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly]
    ]
    def status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly]
    def updateDateTime: Timestamp
    def workspaceId: Id
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExtendsFrom: ZIO[Any, AwsError, List[ComponentTypeId]] =
      AwsError.unwrapOptionField("extendsFrom", extendsFrom)
    def getFunctions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("functions", functions)
    def getIsAbstract: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAbstract", isAbstract)
    def getIsSchemaInitialized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSchemaInitialized", isSchemaInitialized)
    def getIsSingleton: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSingleton", isSingleton)
    def getPropertyDefinitions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyDefinitions", propertyDefinitions)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Status.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
  ) extends zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val extendsFrom: Optional[List[ComponentTypeId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendsFrom())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.ComponentTypeId(item)
          }.toList
        )
    override val functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.functions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.FunctionResponse.wrap(value)
          })
          .toMap
      )
    override val isAbstract: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAbstract())
      .map(value => value: Boolean)
    override val isSchemaInitialized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSchemaInitialized())
      .map(value => value: Boolean)
    override val isSingleton: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSingleton())
      .map(value => value: Boolean)
    override val propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyDefinitions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyDefinitionResponse
              .wrap(value)
          })
          .toMap
      )
    override val status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iottwinmaker.model.Status.wrap(value))
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
  ): zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
