package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPropertyValueHistoryResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    propertyValues: Iterable[zio.aws.iottwinmaker.model.PropertyValueHistory]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse = {
    import GetPropertyValueHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .propertyValues(propertyValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse
      .wrap(buildAwsValue())
}
object GetPropertyValueHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse =
      zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse(
        nextToken.map(value => value),
        propertyValues.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def propertyValues
        : List[zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPropertyValues: ZIO[Any, Nothing, List[
      zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly
    ]] = ZIO.succeed(propertyValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val propertyValues
        : List[zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly] = impl
      .propertyValues()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.PropertyValueHistory.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
  ): zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
