package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSceneRequest(sceneId: Id, workspaceId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest = {
    import GetSceneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
      .builder()
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetSceneRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetSceneRequest.wrap(buildAwsValue())
}
object GetSceneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetSceneRequest =
      zio.aws.iottwinmaker.model.GetSceneRequest(sceneId, workspaceId)
    def sceneId: Id
    def workspaceId: Id
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
  ) extends zio.aws.iottwinmaker.model.GetSceneRequest.ReadOnly {
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
  ): zio.aws.iottwinmaker.model.GetSceneRequest.ReadOnly = new Wrapper(impl)
}
