package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  RoleArn,
  S3Location,
  TwinMakerArn,
  Timestamp,
  Description,
  Id
}
import scala.jdk.CollectionConverters.*
final case class GetWorkspaceResponse(
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    role: RoleArn,
    s3Location: S3Location,
    updateDateTime: Timestamp,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse = {
    import GetWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .role(RoleArn.unwrap(role): java.lang.String)
      .s3Location(S3Location.unwrap(s3Location): java.lang.String)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetWorkspaceResponse.wrap(buildAwsValue())
}
object GetWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetWorkspaceResponse =
      zio.aws.iottwinmaker.model.GetWorkspaceResponse(
        arn,
        creationDateTime,
        description.map(value => value),
        role,
        s3Location,
        updateDateTime,
        workspaceId
      )
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def description: Optional[Description]
    def role: RoleArn
    def s3Location: S3Location
    def updateDateTime: Timestamp
    def workspaceId: Id
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(role)
    def getS3Location: ZIO[Any, Nothing, S3Location] = ZIO.succeed(s3Location)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
  ) extends zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val role: RoleArn =
      zio.aws.iottwinmaker.model.primitives.RoleArn(impl.role())
    override val s3Location: S3Location =
      zio.aws.iottwinmaker.model.primitives.S3Location(impl.s3Location())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
  ): zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
