package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{Id, NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListScenesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest = {
    import ListScenesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListScenesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListScenesRequest.wrap(buildAwsValue())
}
object ListScenesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListScenesRequest =
      zio.aws.iottwinmaker.model.ListScenesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        workspaceId
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def workspaceId: Id
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest
  ) extends zio.aws.iottwinmaker.model.ListScenesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest
  ): zio.aws.iottwinmaker.model.ListScenesRequest.ReadOnly = new Wrapper(impl)
}
