package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListScenesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    sceneSummaries: Optional[
      Iterable[zio.aws.iottwinmaker.model.SceneSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse = {
    import ListScenesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        sceneSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sceneSummaries)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListScenesResponse.wrap(buildAwsValue())
}
object ListScenesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListScenesResponse =
      zio.aws.iottwinmaker.model.ListScenesResponse(
        nextToken.map(value => value),
        sceneSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def sceneSummaries
        : Optional[List[zio.aws.iottwinmaker.model.SceneSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSceneSummaries: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.SceneSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("sceneSummaries", sceneSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ) extends zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val sceneSummaries
        : Optional[List[zio.aws.iottwinmaker.model.SceneSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sceneSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.SceneSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ): zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly = new Wrapper(impl)
}
