package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PropertyFilter(
    operator: Optional[String] = Optional.Absent,
    propertyName: Optional[String] = Optional.Absent,
    value: Optional[zio.aws.iottwinmaker.model.DataValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter = {
    import PropertyFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter
      .builder()
      .optionallyWith(operator.map(value => value: java.lang.String))(
        _.operator
      )
      .optionallyWith(propertyName.map(value => value: java.lang.String))(
        _.propertyName
      )
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyFilter.wrap(buildAwsValue())
}
object PropertyFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyFilter =
      zio.aws.iottwinmaker.model.PropertyFilter(
        operator.map(value => value),
        propertyName.map(value => value),
        value.map(value => value.asEditable)
      )
    def operator: Optional[String]
    def propertyName: Optional[String]
    def value: Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def getOperator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operator", operator)
    def getPropertyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("propertyName", propertyName)
    def getValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter
  ) extends zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly {
    override val operator: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operator())
      .map(value => value: String)
    override val propertyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyName())
      .map(value => value: String)
    override val value
        : Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter
  ): zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly = new Wrapper(impl)
}
