package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Status(
    error: Optional[zio.aws.iottwinmaker.model.ErrorDetails] = Optional.Absent,
    state: Optional[zio.aws.iottwinmaker.model.State] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.Status = {
    import Status.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.Status
      .builder()
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.Status.ReadOnly =
    zio.aws.iottwinmaker.model.Status.wrap(buildAwsValue())
}
object Status {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.Status
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.Status =
      zio.aws.iottwinmaker.model
        .Status(error.map(value => value.asEditable), state.map(value => value))
    def error: Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly]
    def state: Optional[zio.aws.iottwinmaker.model.State]
    def getError
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
    def getState: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.State] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Status
  ) extends zio.aws.iottwinmaker.model.Status.ReadOnly {
    override val error
        : Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iottwinmaker.model.ErrorDetails.wrap(value))
    override val state: Optional[zio.aws.iottwinmaker.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iottwinmaker.model.State.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Status
  ): zio.aws.iottwinmaker.model.Status.ReadOnly = new Wrapper(impl)
}
