package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Id,
  Name,
  Description,
  ComponentTypeId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateComponentTypeRequest(
    componentTypeId: ComponentTypeId,
    description: Optional[Description] = Optional.Absent,
    extendsFrom: Optional[Iterable[ComponentTypeId]] = Optional.Absent,
    functions: Optional[Map[Name, zio.aws.iottwinmaker.model.FunctionRequest]] =
      Optional.Absent,
    isSingleton: Optional[Boolean] = Optional.Absent,
    propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest]
    ] = Optional.Absent,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest = {
    import UpdateComponentTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
      .builder()
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        extendsFrom.map(value =>
          value.map { item =>
            ComponentTypeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.extendsFrom)
      .optionallyWith(
        functions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.functions)
      .optionallyWith(isSingleton.map(value => value: java.lang.Boolean))(
        _.isSingleton
      )
      .optionallyWith(
        propertyDefinitions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyDefinitions)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.wrap(buildAwsValue())
}
object UpdateComponentTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateComponentTypeRequest =
      zio.aws.iottwinmaker.model.UpdateComponentTypeRequest(
        componentTypeId,
        description.map(value => value),
        extendsFrom.map(value => value),
        functions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        isSingleton.map(value => value),
        propertyDefinitions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        workspaceId
      )
    def componentTypeId: ComponentTypeId
    def description: Optional[Description]
    def extendsFrom: Optional[List[ComponentTypeId]]
    def functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly]
    ]
    def isSingleton: Optional[Boolean]
    def propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly]
    ]
    def workspaceId: Id
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExtendsFrom: ZIO[Any, AwsError, List[ComponentTypeId]] =
      AwsError.unwrapOptionField("extendsFrom", extendsFrom)
    def getFunctions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("functions", functions)
    def getIsSingleton: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSingleton", isSingleton)
    def getPropertyDefinitions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyDefinitions", propertyDefinitions)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
  ) extends zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.ReadOnly {
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val extendsFrom: Optional[List[ComponentTypeId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendsFrom())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.ComponentTypeId(item)
          }.toList
        )
    override val functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.functions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.FunctionRequest.wrap(value)
          })
          .toMap
      )
    override val isSingleton: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSingleton())
      .map(value => value: Boolean)
    override val propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyDefinitions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives
              .Name(key) -> zio.aws.iottwinmaker.model.PropertyDefinitionRequest
              .wrap(value)
          })
          .toMap
      )
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
  ): zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.ReadOnly =
    new Wrapper(impl)
}
