package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Id, RoleArn, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceRequest(
    description: Optional[Description] = Optional.Absent,
    role: Optional[RoleArn] = Optional.Absent,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest = {
    import UpdateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        role.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.role)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateWorkspaceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateWorkspaceRequest.wrap(buildAwsValue())
}
object UpdateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateWorkspaceRequest =
      zio.aws.iottwinmaker.model.UpdateWorkspaceRequest(
        description.map(value => value),
        role.map(value => value),
        workspaceId
      )
    def description: Optional[Description]
    def role: Optional[RoleArn]
    def workspaceId: Id
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("role", role)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest
  ) extends zio.aws.iottwinmaker.model.UpdateWorkspaceRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val role: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.iottwinmaker.model.primitives.RoleArn(value))
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest
  ): zio.aws.iottwinmaker.model.UpdateWorkspaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
