package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Name,
  Description,
  ComponentTypeId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentRequest(
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest = {
    import ComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
      .builder()
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentRequest.wrap(buildAwsValue())
}
object ComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentRequest =
      zio.aws.iottwinmaker.model.ComponentRequest(
        componentTypeId.map(value => value),
        description.map(value => value),
        properties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def componentTypeId: Optional[ComponentTypeId]
    def description: Optional[Description]
    def properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ]
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getProperties: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ) extends zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly {
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyRequest.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ): zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly = new Wrapper(impl)
}
