package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{EntityId, Timestamp, TwinMakerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateEntityResponse(
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    entityId: EntityId,
    state: zio.aws.iottwinmaker.model.State
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse = {
    import CreateEntityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly =
    zio.aws.iottwinmaker.model.CreateEntityResponse.wrap(buildAwsValue())
}
object CreateEntityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateEntityResponse =
      zio.aws.iottwinmaker.model.CreateEntityResponse(
        arn,
        creationDateTime,
        entityId,
        state
      )
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def entityId: EntityId
    def state: zio.aws.iottwinmaker.model.State
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getState: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.State] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
  ) extends zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val state: zio.aws.iottwinmaker.model.State =
      zio.aws.iottwinmaker.model.State.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
  ): zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly = new Wrapper(
    impl
  )
}
