package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Id, ComponentTypeId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteComponentTypeRequest(
    componentTypeId: ComponentTypeId,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest = {
    import DeleteComponentTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest
      .builder()
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.DeleteComponentTypeRequest.ReadOnly =
    zio.aws.iottwinmaker.model.DeleteComponentTypeRequest.wrap(buildAwsValue())
}
object DeleteComponentTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DeleteComponentTypeRequest =
      zio.aws.iottwinmaker.model
        .DeleteComponentTypeRequest(componentTypeId, workspaceId)
    def componentTypeId: ComponentTypeId
    def workspaceId: Id
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest
  ) extends zio.aws.iottwinmaker.model.DeleteComponentTypeRequest.ReadOnly {
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest
  ): zio.aws.iottwinmaker.model.DeleteComponentTypeRequest.ReadOnly =
    new Wrapper(impl)
}
