package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FunctionRequest(
    implementedBy: Optional[zio.aws.iottwinmaker.model.DataConnector] =
      Optional.Absent,
    requiredProperties: Optional[Iterable[Name]] = Optional.Absent,
    scope: Optional[zio.aws.iottwinmaker.model.Scope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.FunctionRequest = {
    import FunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.FunctionRequest
      .builder()
      .optionallyWith(implementedBy.map(value => value.buildAwsValue()))(
        _.implementedBy
      )
      .optionallyWith(
        requiredProperties.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiredProperties)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly =
    zio.aws.iottwinmaker.model.FunctionRequest.wrap(buildAwsValue())
}
object FunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.FunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.FunctionRequest =
      zio.aws.iottwinmaker.model.FunctionRequest(
        implementedBy.map(value => value.asEditable),
        requiredProperties.map(value => value),
        scope.map(value => value)
      )
    def implementedBy
        : Optional[zio.aws.iottwinmaker.model.DataConnector.ReadOnly]
    def requiredProperties: Optional[List[Name]]
    def scope: Optional[zio.aws.iottwinmaker.model.Scope]
    def getImplementedBy: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.DataConnector.ReadOnly
    ] = AwsError.unwrapOptionField("implementedBy", implementedBy)
    def getRequiredProperties: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("requiredProperties", requiredProperties)
    def getScope: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.FunctionRequest
  ) extends zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly {
    override val implementedBy
        : Optional[zio.aws.iottwinmaker.model.DataConnector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.implementedBy())
        .map(value => zio.aws.iottwinmaker.model.DataConnector.wrap(value))
    override val requiredProperties: Optional[List[Name]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.Name(item)
          }.toList
        )
    override val scope: Optional[zio.aws.iottwinmaker.model.Scope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.iottwinmaker.model.Scope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.FunctionRequest
  ): zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly = new Wrapper(impl)
}
