package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ComponentTypeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListComponentTypesFilter(
    extendsFrom: Optional[ComponentTypeId] = Optional.Absent,
    isAbstract: Optional[Boolean] = Optional.Absent,
    namespace: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesFilter = {
    import ListComponentTypesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesFilter
      .builder()
      .optionallyWith(
        extendsFrom.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.extendsFrom)
      .optionallyWith(isAbstract.map(value => value: java.lang.Boolean))(
        _.isAbstract
      )
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly =
    zio.aws.iottwinmaker.model.ListComponentTypesFilter.wrap(buildAwsValue())
}
object ListComponentTypesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListComponentTypesFilter =
      zio.aws.iottwinmaker.model.ListComponentTypesFilter(
        extendsFrom.map(value => value),
        isAbstract.map(value => value),
        namespace.map(value => value)
      )
    def extendsFrom: Optional[ComponentTypeId]
    def isAbstract: Optional[Boolean]
    def namespace: Optional[String]
    def getExtendsFrom: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("extendsFrom", extendsFrom)
    def getIsAbstract: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAbstract", isAbstract)
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesFilter
  ) extends zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly {
    override val extendsFrom: Optional[ComponentTypeId] = zio.aws.core.internal
      .optionalFromNullable(impl.extendsFrom())
      .map(value =>
        zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
      )
    override val isAbstract: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAbstract())
      .map(value => value: Boolean)
    override val namespace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesFilter
  ): zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly = new Wrapper(
    impl
  )
}
