package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PropertyResponse(
    definition: Optional[
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse
    ] = Optional.Absent,
    value: Optional[zio.aws.iottwinmaker.model.DataValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyResponse = {
    import PropertyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyResponse
      .builder()
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyResponse.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyResponse.wrap(buildAwsValue())
}
object PropertyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyResponse =
      zio.aws.iottwinmaker.model.PropertyResponse(
        definition.map(value => value.asEditable),
        value.map(value => value.asEditable)
      )
    def definition: Optional[
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly
    ]
    def value: Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
    def getValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyResponse
  ) extends zio.aws.iottwinmaker.model.PropertyResponse.ReadOnly {
    override val definition: Optional[
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.definition())
      .map(value =>
        zio.aws.iottwinmaker.model.PropertyDefinitionResponse.wrap(value)
      )
    override val value
        : Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyResponse
  ): zio.aws.iottwinmaker.model.PropertyResponse.ReadOnly = new Wrapper(impl)
}
