package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PropertyValueHistory(
    entityPropertyReference: zio.aws.iottwinmaker.model.EntityPropertyReference,
    values: Optional[Iterable[zio.aws.iottwinmaker.model.PropertyValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyValueHistory = {
    import PropertyValueHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValueHistory
      .builder()
      .entityPropertyReference(entityPropertyReference.buildAwsValue())
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyValueHistory.wrap(buildAwsValue())
}
object PropertyValueHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValueHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyValueHistory =
      zio.aws.iottwinmaker.model.PropertyValueHistory(
        entityPropertyReference.asEditable,
        values.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entityPropertyReference
        : zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly
    def values
        : Optional[List[zio.aws.iottwinmaker.model.PropertyValue.ReadOnly]]
    def getEntityPropertyReference: ZIO[
      Any,
      Nothing,
      zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly
    ] = ZIO.succeed(entityPropertyReference)
    def getValues: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.PropertyValue.ReadOnly
    ]] = AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValueHistory
  ) extends zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly {
    override val entityPropertyReference
        : zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly =
      zio.aws.iottwinmaker.model.EntityPropertyReference
        .wrap(impl.entityPropertyReference())
    override val values
        : Optional[List[zio.aws.iottwinmaker.model.PropertyValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.PropertyValue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValueHistory
  ): zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly = new Wrapper(
    impl
  )
}
