package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ComponentTypeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Relationship(
    relationshipType: Optional[String] = Optional.Absent,
    targetComponentTypeId: Optional[ComponentTypeId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.Relationship = {
    import Relationship.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.Relationship
      .builder()
      .optionallyWith(relationshipType.map(value => value: java.lang.String))(
        _.relationshipType
      )
      .optionallyWith(
        targetComponentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.targetComponentTypeId)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.Relationship.ReadOnly =
    zio.aws.iottwinmaker.model.Relationship.wrap(buildAwsValue())
}
object Relationship {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.Relationship
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.Relationship =
      zio.aws.iottwinmaker.model.Relationship(
        relationshipType.map(value => value),
        targetComponentTypeId.map(value => value)
      )
    def relationshipType: Optional[String]
    def targetComponentTypeId: Optional[ComponentTypeId]
    def getRelationshipType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("relationshipType", relationshipType)
    def getTargetComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("targetComponentTypeId", targetComponentTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Relationship
  ) extends zio.aws.iottwinmaker.model.Relationship.ReadOnly {
    override val relationshipType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.relationshipType())
      .map(value => value: String)
    override val targetComponentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetComponentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Relationship
  ): zio.aws.iottwinmaker.model.Relationship.ReadOnly = new Wrapper(impl)
}
