package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{TagValue, TagKey, TwinMakerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: TwinMakerArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest
      .builder()
      .resourceARN(TwinMakerArn.unwrap(resourceARN): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.TagResourceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.TagResourceRequest =
      zio.aws.iottwinmaker.model.TagResourceRequest(resourceARN, tags)
    def resourceARN: TwinMakerArn
    def tags: Map[TagKey, TagValue]
    def getResourceARN: ZIO[Any, Nothing, TwinMakerArn] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest
  ) extends zio.aws.iottwinmaker.model.TagResourceRequest.ReadOnly {
    override val resourceARN: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.resourceARN())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iottwinmaker.model.primitives
          .TagKey(key) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest
  ): zio.aws.iottwinmaker.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
