package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Id,
  Description,
  S3Url,
  SceneCapability
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSceneRequest(
    capabilities: Optional[Iterable[SceneCapability]] = Optional.Absent,
    contentLocation: Optional[S3Url] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    sceneId: Id,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest = {
    import UpdateSceneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
      .builder()
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            SceneCapability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .optionallyWith(
        contentLocation.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.contentLocation)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateSceneRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateSceneRequest.wrap(buildAwsValue())
}
object UpdateSceneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateSceneRequest =
      zio.aws.iottwinmaker.model.UpdateSceneRequest(
        capabilities.map(value => value),
        contentLocation.map(value => value),
        description.map(value => value),
        sceneId,
        workspaceId
      )
    def capabilities: Optional[List[SceneCapability]]
    def contentLocation: Optional[S3Url]
    def description: Optional[Description]
    def sceneId: Id
    def workspaceId: Id
    def getCapabilities: ZIO[Any, AwsError, List[SceneCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getContentLocation: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("contentLocation", contentLocation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
  ) extends zio.aws.iottwinmaker.model.UpdateSceneRequest.ReadOnly {
    override val capabilities: Optional[List[SceneCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.SceneCapability(item)
          }.toList
        )
    override val contentLocation: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.contentLocation())
      .map(value => zio.aws.iottwinmaker.model.primitives.S3Url(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
  ): zio.aws.iottwinmaker.model.UpdateSceneRequest.ReadOnly = new Wrapper(impl)
}
