package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchPutPropertyErrorEntry(
    errors: Iterable[zio.aws.iottwinmaker.model.BatchPutPropertyError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyErrorEntry = {
    import BatchPutPropertyErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyErrorEntry
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.ReadOnly =
    zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.wrap(buildAwsValue())
}
object BatchPutPropertyErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry =
      zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry(errors.map { item =>
        item.asEditable
      })
    def errors: List[zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyErrorEntry
  ) extends zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.ReadOnly {
    override val errors
        : List[zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.BatchPutPropertyError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyErrorEntry
  ): zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.ReadOnly =
    new Wrapper(impl)
}
