package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchPutPropertyValuesRequest(
    workspaceId: Id,
    entries: Iterable[zio.aws.iottwinmaker.model.PropertyValueEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest = {
    import BatchPutPropertyValuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest
      .wrap(buildAwsValue())
}
object BatchPutPropertyValuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest =
      zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest(
        workspaceId,
        entries.map { item =>
          item.asEditable
        }
      )
    def workspaceId: Id
    def entries: List[zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
  ) extends zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val entries
        : List[zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.PropertyValueEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
  ): zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest.ReadOnly =
    new Wrapper(impl)
}
