package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Name,
  ComponentTypeId,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentUpdateRequest(
    updateType: Optional[zio.aws.iottwinmaker.model.ComponentUpdateType] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    propertyUpdates: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest]
    ] = Optional.Absent,
    propertyGroupUpdates: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest = {
    import ComponentUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
      .builder()
      .optionallyWith(updateType.map(value => value.unwrap))(_.updateType)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        propertyUpdates.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyUpdates)
      .optionallyWith(
        propertyGroupUpdates.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyGroupUpdates)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentUpdateRequest.wrap(buildAwsValue())
}
object ComponentUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentUpdateRequest =
      zio.aws.iottwinmaker.model.ComponentUpdateRequest(
        updateType.map(value => value),
        description.map(value => value),
        componentTypeId.map(value => value),
        propertyUpdates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        propertyGroupUpdates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def updateType: Optional[zio.aws.iottwinmaker.model.ComponentUpdateType]
    def description: Optional[Description]
    def componentTypeId: Optional[ComponentTypeId]
    def propertyUpdates: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ]
    def propertyGroupUpdates: Optional[Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly
    ]]
    def getUpdateType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ComponentUpdateType] =
      AwsError.unwrapOptionField("updateType", updateType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getPropertyUpdates: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyUpdates", propertyUpdates)
    def getPropertyGroupUpdates: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("propertyGroupUpdates", propertyGroupUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
  ) extends zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly {
    override val updateType
        : Optional[zio.aws.iottwinmaker.model.ComponentUpdateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateType())
        .map(value =>
          zio.aws.iottwinmaker.model.ComponentUpdateType.wrap(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val propertyUpdates: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyUpdates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyRequest.wrap(value)
          })
          .toMap
      )
    override val propertyGroupUpdates: Optional[Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyGroupUpdates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateRequest
  ): zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly = new Wrapper(
    impl
  )
}
