package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters.*
sealed trait ComponentUpdateType {
  def unwrap
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType
}
object ComponentUpdateType {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType
  ): zio.aws.iottwinmaker.model.ComponentUpdateType = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.ComponentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE extends zio.aws.iottwinmaker.model.ComponentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.CREATE
  }
  case object UPDATE extends zio.aws.iottwinmaker.model.ComponentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.UPDATE
  }
  case object DELETE extends zio.aws.iottwinmaker.model.ComponentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.ComponentUpdateType.DELETE
  }
}
