package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Timestamp, TwinMakerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateComponentTypeResponse(
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    state: zio.aws.iottwinmaker.model.State
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse = {
    import CreateComponentTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly =
    zio.aws.iottwinmaker.model.CreateComponentTypeResponse.wrap(buildAwsValue())
}
object CreateComponentTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateComponentTypeResponse =
      zio.aws.iottwinmaker.model
        .CreateComponentTypeResponse(arn, creationDateTime, state)
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def state: zio.aws.iottwinmaker.model.State
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getState: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.State] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse
  ) extends zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val state: zio.aws.iottwinmaker.model.State =
      zio.aws.iottwinmaker.model.State.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse
  ): zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly =
    new Wrapper(impl)
}
