package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  SceneMetadataValue,
  SceneCapability,
  TagValue,
  S3Url,
  Description,
  Name,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSceneRequest(
    workspaceId: Id,
    sceneId: Id,
    contentLocation: S3Url,
    description: Optional[Description] = Optional.Absent,
    capabilities: Optional[Iterable[SceneCapability]] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    sceneMetadata: Optional[Map[Name, SceneMetadataValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest = {
    import CreateSceneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .contentLocation(S3Url.unwrap(contentLocation): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            SceneCapability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        sceneMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (SceneMetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.sceneMetadata)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateSceneRequest.ReadOnly =
    zio.aws.iottwinmaker.model.CreateSceneRequest.wrap(buildAwsValue())
}
object CreateSceneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateSceneRequest =
      zio.aws.iottwinmaker.model.CreateSceneRequest(
        workspaceId,
        sceneId,
        contentLocation,
        description.map(value => value),
        capabilities.map(value => value),
        tags.map(value => value),
        sceneMetadata.map(value => value)
      )
    def workspaceId: Id
    def sceneId: Id
    def contentLocation: S3Url
    def description: Optional[Description]
    def capabilities: Optional[List[SceneCapability]]
    def tags: Optional[Map[TagKey, TagValue]]
    def sceneMetadata: Optional[Map[Name, SceneMetadataValue]]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getContentLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(contentLocation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapabilities: ZIO[Any, AwsError, List[SceneCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSceneMetadata: ZIO[Any, AwsError, Map[Name, SceneMetadataValue]] =
      AwsError.unwrapOptionField("sceneMetadata", sceneMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
  ) extends zio.aws.iottwinmaker.model.CreateSceneRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val contentLocation: S3Url =
      zio.aws.iottwinmaker.model.primitives.S3Url(impl.contentLocation())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val capabilities: Optional[List[SceneCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.SceneCapability(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.TagKey(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val sceneMetadata: Optional[Map[Name, SceneMetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sceneMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iottwinmaker.model.primitives
                .Name(key) -> zio.aws.iottwinmaker.model.primitives
                .SceneMetadataValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
  ): zio.aws.iottwinmaker.model.CreateSceneRequest.ReadOnly = new Wrapper(impl)
}
