package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  RoleArn,
  TagValue,
  SyncSource,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSyncJobRequest(
    workspaceId: Id,
    syncSource: SyncSource,
    syncRole: RoleArn,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest = {
    import CreateSyncJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .syncSource(SyncSource.unwrap(syncSource): java.lang.String)
      .syncRole(RoleArn.unwrap(syncRole): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateSyncJobRequest.ReadOnly =
    zio.aws.iottwinmaker.model.CreateSyncJobRequest.wrap(buildAwsValue())
}
object CreateSyncJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateSyncJobRequest =
      zio.aws.iottwinmaker.model.CreateSyncJobRequest(
        workspaceId,
        syncSource,
        syncRole,
        tags.map(value => value)
      )
    def workspaceId: Id
    def syncSource: SyncSource
    def syncRole: RoleArn
    def tags: Optional[Map[TagKey, TagValue]]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSyncSource: ZIO[Any, Nothing, SyncSource] = ZIO.succeed(syncSource)
    def getSyncRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(syncRole)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest
  ) extends zio.aws.iottwinmaker.model.CreateSyncJobRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val syncSource: SyncSource =
      zio.aws.iottwinmaker.model.primitives.SyncSource(impl.syncSource())
    override val syncRole: RoleArn =
      zio.aws.iottwinmaker.model.primitives.RoleArn(impl.syncRole())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.TagKey(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest
  ): zio.aws.iottwinmaker.model.CreateSyncJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
